﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using Remoting;

namespace Client
{
	class Program
	{
		static void Main(string[] args)
		{
			while (true)
			{
				try
				{
					using (RSocket transport = new RClientSocket("192.168.25.115", Config.PORT))
					{
						using (RMessagePipe messagePipe = new RMessagePipe(transport))
						{
							using (RProcessor processor = new RProcessor(messagePipe, new ClientActionHandler()))
							{
								Console.WriteLine("Client connected as: {0}", messagePipe);
								bool alive = true;
								while (alive)
								{
									// do asynch communication
									try
									{
										processor.Do("hellou", processor.ToString(), true, false, 0, "wazzap");
									}
									catch (Exception ex)
									{
										Console.WriteLine("Lost connection to server: {0}", ex);
										alive = false;
									}

									Thread.Sleep(1000);
								}
							}
						}
					}
				}
				catch (Exception ex)
				{
					// could not connect
					Console.WriteLine("Could not connect to server: {0}", ex);
				}
			}
		}
	}
}
